/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.IVWListUpdateListener;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWCachedSecurityList;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWUsersAndGroupsPanel;
import filenet.vw.toolkit.utils.images.VWBaseImageLoader;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWParticipantListCellRenderer;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

class VWAppSpaceSecurityPanel
extends VWUsersAndGroupsPanel
implements IVWListUpdateListener {
    protected VWSessionInfo m_sessionInfo = null;
    protected VWApplicationSpaceDefinition m_appSpaceDef = null;

    public VWAppSpaceSecurityPanel(Container parentContainer, VWSessionInfo sessionInfo, VWApplicationSpaceDefinition appSpaceDef) {
        super(parentContainer, sessionInfo.getSession());
        try {
            this.m_sessionInfo = sessionInfo;
            this.m_appSpaceDef = appSpaceDef;
            this.addListUpdateListener(this);
            this.setListCellRenderer(new VWParticipantListCellRenderer());
            this.m_availableParticipants = this.createAvailableItemArray();
            VWParticipantItem[] selectedParticipantItems = null;
            VWParticipant[] selectedParticipants = this.m_appSpaceDef.getWriteSecurityPx();
            if (selectedParticipants != null && selectedParticipants.length > 0) {
                selectedParticipantItems = new VWParticipantItem[selectedParticipants.length];
                for (int nIndex = 0; nIndex < selectedParticipants.length; ++nIndex) {
                    selectedParticipantItems[nIndex] = new VWParticipantItem(selectedParticipants[nIndex]);
                }
            }
            super.initializeLists(this.m_availableParticipants, selectedParticipantItems);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean validateAccessList() {
        VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
        for (int nIndex = 0; nIndex < listModel.getSize(); ++nIndex) {
            VWParticipantItem vwParticipantItem = (VWParticipantItem)listModel.elementAt(nIndex);
            if (vwParticipantItem.getType() != -1) continue;
            String sInvalidUserName = vwParticipantItem.getDisplayName();
            String errMsg = VWResource.SecurityListHasInvalidUser.toString("'" + sInvalidUserName + "'");
            JOptionPane.showMessageDialog(this.m_parentContainer, errMsg, null, 0, null);
            return false;
        }
        return true;
    }

    public VWParticipant[] getWriteSecurityPx() {
        Vector<VWParticipant> list = new Vector<VWParticipant>();
        VWSortedListModel listModel = (VWSortedListModel)this.m_selectedList.getModel();
        for (int nIndex = 0; nIndex < listModel.getSize(); ++nIndex) {
            VWParticipantItem vwParticipantItem = (VWParticipantItem)listModel.elementAt(nIndex);
            list.addElement(vwParticipantItem.getVWParticipant());
        }
        if (list.size() == 0) {
            return null;
        }
        Object[] accessList = new VWParticipant[list.size()];
        list.copyInto(accessList);
        return accessList;
    }

    public void releaseResources() {
        this.m_sessionInfo = null;
        super.releaseResources();
        this.removeAll();
    }

    public void listUpdated(Object source, int nEventType, Object[] items) {
        switch (nEventType) {
            default: 
        }
    }

    protected void addControls() {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(3, 3, 3, 3);
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.fill = 1;
            this.m_availableList = new JList(new VWSortedListModel());
            this.m_availableList.addListSelectionListener(this);
            this.m_availableList.addMouseListener(new VWMouseAdapter(this));
            this.add((Component)this.createAvailableListPanel(this.m_availableList), gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_availableList, this, VWResource.AvailableUserOrGroupList, VWResource.AvailableUserOrGroupList);
            this.m_availableList.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbCons.anchor = 10;
            gbCons.gridx = 1;
            gbCons.fill = 3;
            gbCons.weightx = 0.0;
            this.add((Component)this.createAddRemoveButtonPanel(), gbCons);
            gbCons.gridx = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.fill = 1;
            this.m_selectedList = new JList(new VWSortedListModel());
            this.m_selectedList.addListSelectionListener(this);
            this.add((Component)this.createSelectedListPanel(this.m_selectedList), gbCons);
            VWAccessibilityHelper.setAccessibility(this.m_selectedList, this, VWResource.SelectedUserOrGroupList, VWResource.SelectedUserOrGroupList);
            this.m_selectedList.addKeyListener(VWKeyAdapter.s_keyAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected JPanel createAvailableListPanel(JList list) {
        try {
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.fill = 2;
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.TypeAheadLabel));
            mainPanel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.TypeAheadLabel, VWResource.TypeAheadLabel);
            label.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_typeAheadName = new JTextField();
            this.m_typeAheadName.getDocument().addDocumentListener(this);
            this.m_typeAheadName.addKeyListener(this);
            ++gbConst.gridy;
            mainPanel.add((Component)this.m_typeAheadName, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_typeAheadName, this, VWResource.EnterNameToSearch, VWResource.EnterNameToSearch);
            VWAccessibilityHelper.setLabelFor(label, this.m_typeAheadName);
            this.m_typeAheadName.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.fill = 1;
            ++gbConst.gridy;
            gbConst.weighty = 1.0;
            mainPanel.add((Component)new JScrollPane(list), gbConst);
            return mainPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createAddRemoveButtonPanel() {
        try {
            JPanel panel = new JPanel(new GridBagLayout());
            GridBagConstraints gbConst = new GridBagConstraints();
            gbConst.anchor = 10;
            gbConst.fill = 0;
            gbConst.gridx = 0;
            gbConst.gridy = -1;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(3, 0, 3, 0);
            if (this.m_bShowMoveAllButtons) {
                this.m_addAllButton = new JButton(VWImageLoader.createImageIcon("addall.gif"));
                this.m_addAllButton.setToolTipText(VWResource.s_addAll);
                this.m_addAllButton.setMargin(new Insets(1, 1, 1, 1));
                this.m_addAllButton.addActionListener(this);
                VWBaseImageLoader.enableIconComponentOrientation(this.m_addAllButton);
                panel.add((Component)this.m_addAllButton, gbConst);
                VWAccessibilityHelper.setAccessibility(this.m_addAllButton, this, VWResource.s_addAll, VWResource.s_addAll);
                this.m_addAllButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            this.m_addButton = new JButton(VWImageLoader.createImageIcon("add.gif"));
            this.m_addButton.setToolTipText(VWResource.s_add);
            this.m_addButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_addButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_addButton);
            panel.add((Component)this.m_addButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_addButton, this, VWResource.s_addAll, VWResource.s_add);
            this.m_addButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_removeButton = new JButton(VWImageLoader.createImageIcon("remove.gif"));
            this.m_removeButton.setToolTipText(VWResource.s_remove);
            this.m_removeButton.setMargin(new Insets(1, 1, 1, 1));
            this.m_removeButton.addActionListener(this);
            VWBaseImageLoader.enableIconComponentOrientation(this.m_removeButton);
            panel.add((Component)this.m_removeButton, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_removeButton, this, VWResource.s_remove, VWResource.s_remove);
            this.m_removeButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            if (this.m_bShowMoveAllButtons) {
                this.m_removeAllButton = new JButton(VWImageLoader.createImageIcon("removeall.gif"));
                this.m_removeAllButton.setToolTipText(VWResource.s_removeAll);
                this.m_removeAllButton.setMargin(new Insets(1, 1, 1, 1));
                this.m_removeAllButton.addActionListener(this);
                VWBaseImageLoader.enableIconComponentOrientation(this.m_removeAllButton);
                panel.add((Component)this.m_removeAllButton, gbConst);
                VWAccessibilityHelper.setAccessibility(this.m_removeAllButton, this, VWResource.s_removeAll, VWResource.s_removeAll);
                this.m_removeAllButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            }
            return panel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected JPanel createSelectedListPanel(JList list) {
        try {
            JPanel selectedPanel = new JPanel();
            selectedPanel.setLayout(new BorderLayout());
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.SelectedUsers));
            selectedPanel.add((Component)label, "First");
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.SelectedUsers, VWResource.SelectedUsers);
            label.addKeyListener(VWKeyAdapter.s_keyAdapter);
            selectedPanel.add((Component)new JScrollPane(list), "Center");
            VWAccessibilityHelper.setLabelFor(label, list);
            return selectedPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected VWParticipantItem[] createAvailableItemArray() throws Exception {
        return VWCachedSecurityList.getUsersAndGroupsParticipant(this.m_vwSession);
    }
}

